/*--------------------------------------
    icon.h - h stands for hell

    Mark & Marc,  5/31/93 12:35:36
*/

#pragma noroot
#pragma lint 3
#pragma memorymodel 0
#pragma optimize 14
/*  #pragma debug -1   */

#include <foundation.h>
#include <event.h>
#include <textedit.h>
#include <window.h>
#include <memory.h>
#include <quickdraw.h>
#include <qdaux.h>
#include <intmath.h>
#include <stdio.h>

#define  FOR_SELECTOR		(1 << 10)
#define  MenuBarHeight		13	/* height of system menu bar */
#define  WTitleHeight		12	/* height of standard window title bar */
#define  ScrollBarHeight	13	/* height of standard scrollbar */
#define  ScrollBarWidth		13	/* width of standard scrollbar (use * hOffset)*/
#define  BucketTool	        0	/* fill */
#define  EraserTool	        1   /* draw line tool */
#define  PickerTool	        2	/* pick color */
#define  LineTool	        3   /* draw line tool */
#define  PencilTool	        4	/* bit paint */
#define  ShifterTool        5	/* shifter */
#define  ICNDISPWIN         0x1L    /* icon mode display window */
#define  MAKEMASKITEM		0x0401L /* create mask menu item */
#define  COPYMASKITEM	    0x0402L /* copy icon to mask menu item */
#define  IMPORTITEM			0x0403L /* import icon menu item */


struct timeData {				/* size = 8 bytes */
	char		timebytes[8];
	};
typedef struct timeData timeData, *timeDataPtr, **timeDataHndl;

struct OneDocData {				/* size = 110 bytes long */
	word			size;
	word			offsetToFlags;
	word			numResults;		/* must be 4 or 5 */
	word			result;		
	long			rFinderPathID;
	long			internal1;		/* must be 0 */
	long			iconID;
	long			internal2;
	long			smIconID;
	long			internal3;
	handle		    docStringHndl;
	long			matchFlags;
	word			fileType;			/* matchFileType */
	long			auxMask;			/* matchAuxType */
	long			auxType;			/* matchAuxType */
	handle		    fileNameHndl;		/* matchFileName */
	word			CcompareSpec;		/* matchCreateDateTime */
	timeData		CtimeRec;			/* matchCreateDateTime */
	word			McompareSpec;		/* matchModDateTime */
	timeData		MtimeRec;			/* matchModDateTime */
	word			LAmask;			    /* matchLocalAccess */
	word			LAvalue;			/* matchLocalAccess */
	long			NAmask;			    /* matchNetworkAccess */
	long			NAvalue;			/* matchNetworkAccess */
	word			extMask;			/* matchExtended */
	word			compareValue;		/* matchExtended */
	long			HFSfileType;		/* matchHFSFileType */
	long			HFScreator;			/* matchHFSCreator */
	word			OptionListCount;	/* matchOptionList */
	handle		    OptionListHndl;		/* matchOptionList */
	word			eofCompSpec;		/* match EOF */
	long			eof;				/* match EOF */
	};
typedef struct OneDocData OneDocData, *OneDocDataPtr, **OneDocDataHndl;

struct BundleStruct {				/* size = 18 + (oneDocCount * 4) bytes */
	word			version;
	word			offset;
	long			iconID;		    /* rID for Application Icon */
	long			bundleID;		/* this bundle's resID */
	long			forFinder;		/* reserved, must be 0 */
	word			oneDocCount;	/* number of oneDocs in bundle */
	OneDocDataHndl	oneDocHndl[];	/* oneDoc Handle array */
};
typedef struct BundleStruct BundleStruct, *BundleStructPtr, **BundleStructHndl;

struct privateData {
	QDIconRecord	    **editH;	    /* the copy being edited */
	handle		        resData;
	QDIconRecord	    **undoH;		/* copy of icon for undo */
	BundleStructHndl    structH;
	GrafPort		    **imageCache;	/* offscreen image image */
	GrafPort		    **maskCache;	/* offscreen mask image */
	word			    flag;			/*  bit 15  1 = icon  0 = bundle  bit 0 = dirty */
	Rect			    fatIRect;		/* fatbits image rect */
	Rect			    fatMRect;		/* fatbits mask rect */
	Rect			    sizeRect;		/* resize box rect */
	word			    color;		    /* color selected */
	word			    tool;			/* tool selected */
	long			    resID;
	handle		        winTitle;
	handle		        winTempH;
	word			    maskColor;		/* mask color selected */
    word                infoHeight;
	Rect			    iconRect;		/* rect containing icon image */
	Rect			    infoRect;		/* the infoBar rectangle */
    Rect                grafRect;       /* the window portRect */
	Rect			    gFatIRect;		/* fatbits image rect in Globals */
	Rect			    gFatMRect;		/* fatbits mask rect in Globals */
	Rect			    gSizeRect;		/* resize box rect in Globals */
    GrafPortPtr         winP;           /* the GrafPort */
};
typedef struct privateData *privateDataPtr, **privateDataHndl;

#define PRIVATESIZE 122L

struct fileIconData {
	word			dataLength;			/* length of this data record */
	char			owner[64];			/* pathname of owner */	
	char			name[16];			/* name of document or app */
	word			fileType;			/* filetype */
	word			auxType;			/* auxType */
	byte			largeIcon;
	};
typedef struct fileIconData fileIconData, *fileIconDataPtr;

union uptr {
	Pointer		    dataPtr;
	char			*bytePtr;
	word			*wordPtr;
	long			*longPtr;
	handle		    *hndlPtr;
	OneDocData		*docPtr;
	BundleStructPtr	bundlePtr;
	timeDataPtr		timePtr;
    long            base;
};
typedef union uptr uptr;

union suPtr {
	char			*bPtr;
	word			*wPtr;
};
typedef union suPtr suPtr;

union morph {
	long			lng;
	word			wrd[2];
};
typedef union morph morph;

/* Prototypes */
/* routines in imain.c */
word			    REM_OPEN(fOpenRecPtr);
word			    REM_CLOSE(fCloseRecPtr);
word			    REM_WRITE(fCloseRecPtr);
word			    REM_EVENT(fEventRecPtr);
word			    REM_ACTIVATE(fActivateRecPtr);
word			    REM_GETLINK(fLinkRecPtr);
word			    REM_VIDMODE(fVidModeRecPtr);
word			    REM_PRINT(fCloseRecPtr);
word			    REM_STARTUP(fStartStopRecPtr);
word			    REM_SHUTDOWN(fStartStopRecPtr);

/* routines in Common.c */
void                MakeGlobalRect(Rect *, Rect *);
word                getVid(void);
word                setMaxOf(word, word);
word                setMinOf(word, word);
void                stuffRect(Rect *, word, word, word, word);
handle              loadEdRes(word, word);
void                unloadEdRes(word, word);
void                checkData(GrafPortPtr);
privateDataHndl     getPrivate(GrafPortPtr);
void                CreateOffPort(word, word, GrafPort ***);
void                AdjustOffPort(GrafPort **, word, word);
word                UpdateEditor(GrafPortPtr);
word                EditorMenu(EventRecord *);
void                DrawProc(void);

/* routines in iconstuff.c */
word                iconOpen(privateDataPtr, GrafPortPtr);
void                SetWindowSize(privateDataPtr);
void                DrawInfoBarProc (GrafPortPtr, long, Rect *);
void                InitFatIcon(privateDataPtr);
word                InEditorInfo(EventRecord *);
word                CopyUndoIcon(privateDataPtr);
void                RedrawFatbits(privateDataPtr, word);
void                DisposeSource(GrafPortPtr);
void                copyRows(char *, char *, word, word, word);
void                Icon2Pixmap(QDIconRecord *, GrafPortPtr, word);
void                Pixmap2Icon(GrafPortPtr, QDIconRecord *, word);
void                FillIcon(privateDataPtr, Point, word);
word                FillSource(GrafPortPtr, QDIconRecord **);
void                MakeMask(privateDataPtr);
void                ShiftDraw2(word, word, GrafPortPtr);
void                ShiftIt(privateDataPtr, word, word);
void                ShiftIcon(privateDataPtr, Point);
void                UpdateColor(privateDataPtr);
void                GetPixelRect(word, word, Rect *);
void                SetPixelColor(word, word, word, QDIconRecord *, word);
void                DoBit(word, word, word, word, privateDataPtr);
word                ResizeIt(privateDataPtr, word, word);
void                GrowFat(privateDataPtr, Point);
void                FatClick(EventRecord *);
word                GetPixelColor(word, word, QDIconRecord *, word);
word                PickColor(word, word, privateDataPtr, word);
void                Pt2Pixel(word, word, privateDataPtr, word, word *, word *);
void                RedrawFat2(privateDataPtr);
void                RedrawFat(privateDataPtr);
word                GetColor(word, word, word, privateDataPtr, word);
void                ShiftDraw(word, word, word);
void                PaintImage(GrafPort **, word, word);
void                DrawEditor(void);
void                flopRect(Rect *, Rect *, Rect *);
void                GetPix(word, word, word *, word *, word, privateDataPtr);
void                PutPix(word, word, word, privateDataPtr);
void                drawCoords(privateDataPtr, word, word, word);
void                updateInfoIcon(privateDataPtr);
word                PickColor2(word, word, privateDataPtr, word);

/* routines in bundstuff.c */
word                openBundle(privateDataPtr, GrafPortPtr);
BundleStructHndl    ExtractBundleData(Handle);
OneDocDataPtr       ExtractOneDocData(Handle);
Handle              RebuildBundle(BundleStructHndl);
Handle              RebuildOneDoc(OneDocDataPtr);

/* routines in fatutils.a */
void                DrawFatImage(privateDataHndl);
void                DrawFatMask(privateDataHndl);
void                BOBBY(void);

/* routines in Orca */
word                toolerror(void);
